﻿using Aratek.TrustFinger;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Demo
{
    public partial class ImportForm : Form
    {
        public event EventHandler<EnrollUser> Imported;

        public string FileName { get; set; }
        public ImportForm()
        {
            InitializeComponent();

            this.comboBoxFingerPos.Items.AddRange(new object[] {
            "Unknow",
            "Right Thumb",
            "Right Index Finger",
            "Right Middle Finger",
            "Right Ring Finger",
            "Right Little Finger",
            "Left Thumb",
            "Left Index Finger",
            "Left Middle Finger",
            "Left Ring Finger",
             "Left Little Finger"});
        }

        public ImportForm(FingerPosition position,string file):this()
        {
            comboBoxFingerPos.SelectedIndex = (int)position;
            FileName = file;
            textBoxUserId.MaxLength = 6;
            textBoxFirstName.MaxLength = 20;
            textBoxLastName.MaxLength = 20;
        }

        private void buttonImport_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(textBoxUserId.Text) || string.IsNullOrWhiteSpace(textBoxFirstName.Text))
            {
                MessageBox.Show("User id or first name could not be empty.");
                return;
            }

            using (TrustFingerDbContext db = new TrustFingerDbContext())
            {
                var usr = db.EnrollUser.Where(u => u.UserId == textBoxUserId.Text.Trim());
                if (usr.Count() > 0)
                {
                    MessageBox.Show($"Duplicate user id:{textBoxUserId.Text.Trim()}");
                    return;
                }
            }

            if (comboBoxFingerPos.SelectedIndex<=10&& comboBoxFingerPos.SelectedIndex>=0)
            {
                FingerPosition position = (FingerPosition)comboBoxFingerPos.SelectedIndex;
                EnrollUser user = new EnrollUser();
                user.CreatedTime = DateTime.Now;
                user.UserId = textBoxUserId.Text;
                user.LastName = textBoxLastName.Text; 
                user.FirstName = textBoxFirstName.Text;
                user.FingerPosition = comboBoxFingerPos.SelectedIndex;
                user.FingerPositionName = FormatHelper.FormatFingerprintPosition(position);

                user.FingerData = File.ReadAllBytes(FileName);

                Imported?.Invoke(this, user);
                this.Close();
            }
           
        }

        private void textBoxUserId_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!((e.KeyChar >= '0' && e.KeyChar <= '9') || (e.KeyChar >= 'A' && e.KeyChar <= 'Z') || (e.KeyChar >= 'a' && e.KeyChar <= 'z') || e.KeyChar == '_') && e.KeyChar != (char)8)
            {
                e.Handled = true;
            }
        }

        private void tableLayoutPanel1_Paint(object sender, PaintEventArgs e)
        {

        }
    }
}
